<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Outputs page's Title Bar
 *
 * (!) Should be called after the current $wp_query is already defined
 *
 * @action Before the template: 'us_before_template:templates/titlebar'
 * @action After the template: 'us_after_template:templates/titlebar'
 * @filter Template variables: 'us_template_vars:templates/titlebar'
 */

$public_cpt = array_keys( us_get_public_cpt() );

// Defaults
$titlebar_id = us_get_option( 'titlebar_id' );

// Portfolio Pages
if ( is_singular( array( 'us_portfolio' ) ) ) {
	$titlebar_id = us_get_option( 'titlebar_portfolio_id' );

// Posts
} elseif ( is_singular( array( 'post', 'attachment' ) ) ) {
	$titlebar_id = us_get_option( 'titlebar_post_id' );

// Search Results Page
} elseif ( is_search() ) {
	$titlebar_id = us_get_option( 'titlebar_search_id' );

// Blog Home Page
} elseif ( is_home() ) {
	$titlebar_id = us_get_option( 'titlebar_blog_id' );

// Shop & Products
} elseif ( function_exists( 'is_woocommerce' ) AND is_woocommerce() ) {
	if ( is_product() ) {
		$titlebar_id = us_get_option( 'titlebar_product_id' );
	} else {
		$titlebar_id = us_get_option( 'titlebar_shop_id' );
		if ( ! is_search() AND ! is_tax() ) {
			if ( usof_meta( 'us_titlebar', array(), wc_get_page_id( 'shop' ) ) == 'hide' ) {
				$titlebar_id = '';
			} elseif ( usof_meta( 'us_titlebar', array(), wc_get_page_id( 'shop' ) ) == 'custom' ) {
				$titlebar_id = usof_meta( 'us_titlebar_id', array(), wc_get_page_id( 'shop' ) );
			}
		}
	}

// Archive Pages
} elseif ( is_archive() ) {
	$titlebar_id = us_get_option( 'titlebar_archive_id' );

// Supported custom post types
} elseif ( is_array( $public_cpt ) AND count( $public_cpt ) > 0 AND is_singular( $public_cpt ) ) {
	$post_type = get_post_type();
	$titlebar_id = us_get_option( 'titlebar_' . $post_type . '_id' );
}

// Forums archive page
if ( is_post_type_archive( 'forum' ) ) {
	$titlebar_id = us_get_option( 'titlebar_forum_id' );
}

// Specific page
if ( is_singular() OR ( is_404() AND $page_404 = get_page_by_path( 'error-404' ) ) ) {
	if ( is_singular() ) {
		$postID = get_the_ID();
	} elseif ( is_404() ) {
		$postID = $page_404->ID;
	}
	if ( usof_meta( 'us_titlebar', array(), $postID ) == 'hide' ) {
		$titlebar_id = '';
	} elseif ( usof_meta( 'us_titlebar', array(), $postID ) == 'custom' ) {
		$titlebar_id = usof_meta( 'us_titlebar_id', array(), $postID );
	}
}

// Reset defaults
if ( $titlebar_id == '__defaults__' ) {
	$titlebar_id = us_get_option( 'titlebar_id' );
}

// Output content of Page Block (us_page_block) post
$titlebar_content = '';
if ( $titlebar_id != '' ) {

	$titlebar = get_post( (int) $titlebar_id );

	us_open_wp_query_context();
	if ( $titlebar ) {
		$translated_titlebar_id = apply_filters( 'wpml_object_id', $titlebar->ID, 'us_page_block', TRUE );
		if ( $translated_titlebar_id != $titlebar->ID ) {
			$titlebar = get_post( $translated_titlebar_id );
		}
		global $wp_query, $vc_manager, $us_is_in_titlebar, $us_titlebar_id;
		$us_is_in_titlebar = TRUE;
		$us_titlebar_id = $translated_titlebar_id;
		$wp_query = new WP_Query( array(
			'p' => $translated_titlebar_id,
			'post_type' => 'any'
		) );
		if ( ! empty( $vc_manager ) AND is_object( $vc_manager )) {
			$vc_manager->vc()->addPageCustomCss( $translated_titlebar_id );
			$vc_manager->vc()->addShortcodesCustomCss( $translated_titlebar_id );
		}
		$titlebar_content = $titlebar->post_content;
	}
	us_close_wp_query_context();

	// Apply filters to Page Block content and echoing it ouside of us_open_wp_query_context,
	// so all WP widgets (like WP Nav Menu) would work as they should
	echo apply_filters( 'us_page_block_the_content', $titlebar_content );

	$us_is_in_titlebar = FALSE;
}
