<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Outputs page's Footer
 */

$us_layout = US_Layout::instance();
?>
</div>
<?php
global $us_iframe, $us_hide_footer;
if ( ( ! isset( $us_iframe ) OR ! $us_iframe ) AND ( ! isset( $us_hide_footer ) OR ! $us_hide_footer ) ) {
	do_action( 'us_before_footer' );
?>
<footer class="l-footer"<?php echo ( us_get_option( 'schema_markup' ) ) ? ' itemscope itemtype="https://schema.org/WPFooter"' : ''; ?>>
<?php
$public_cpt = array_keys( us_get_public_cpt() );

// Defaults
$footer_id = us_get_option( 'footer_id' );

// Portfolio Pages
if ( is_singular( array( 'us_portfolio' ) ) ) {
	$footer_id = us_get_option( 'footer_portfolio_id' );

// Posts
} elseif ( is_singular( array( 'post', 'attachment' ) ) ) {
	$footer_id = us_get_option( 'footer_post_id' );

// Search Results Page
} elseif ( is_search() ) {
	$footer_id = us_get_option( 'footer_search_id' );

// Blog Home Page
} elseif ( is_home() ) {
	$footer_id = us_get_option( 'footer_blog_id' );

// Shop & Products
} elseif ( function_exists( 'is_woocommerce' ) AND is_woocommerce() ) {
	if ( is_product() ) {
		$footer_id = us_get_option( 'footer_product_id' );
	} else {
		$footer_id = us_get_option( 'footer_shop_id' );
		if ( ! is_search() AND ! is_tax() ) {
			if ( usof_meta( 'us_footer', array(), wc_get_page_id( 'shop' ) ) == 'hide' ) {
				$footer_id = '';
			} elseif ( usof_meta( 'us_footer', array(), wc_get_page_id( 'shop' ) ) == 'custom' ) {
				$footer_id = usof_meta( 'us_footer_id', array(), wc_get_page_id( 'shop' ) );
			}
		}
	}

// Archive Pages
} elseif ( is_archive() ) {
	$footer_id = us_get_option( 'footer_archive_id' );

// Supported custom post types
} elseif ( is_array( $public_cpt ) AND count( $public_cpt ) > 0 AND is_singular( $public_cpt ) ) {
	$post_type = get_post_type();
	$footer_id = us_get_option( 'footer_' . $post_type . '_id' );
}

// Forums archive page
if ( is_post_type_archive( 'forum' ) ) {
	$footer_id = us_get_option( 'footer_forum_id' );
}

// Specific page
if ( is_singular() OR ( is_404() AND $page_404 = get_page_by_path( 'error-404' ) ) ) {
	if ( is_singular() ) {
		$postID = get_the_ID();
	} elseif ( is_404() ) {
		$postID = $page_404->ID;
	}
	if ( usof_meta( 'us_footer', array(), $postID ) == 'hide' ) {
		$footer_id = '';
	}
	if ( usof_meta( 'us_footer', array(), $postID ) == 'custom' ) {
		$footer_id = usof_meta( 'us_footer_id', array(), $postID );
	}
}

// Reset defaults
if ( $footer_id == '__defaults__' ) {
	$footer_id = us_get_option( 'footer_id' );
}

// Output content of Page Block (us_page_block) post
$footer_content = '';
if ( $footer_id != '' ) {

	$footer = get_post( (int) $footer_id );

	us_open_wp_query_context();
	if ( $footer ) {
		$translated_footer_id = apply_filters( 'wpml_object_id', $footer->ID, 'us_page_block', TRUE );
		if ( $translated_footer_id != $footer->ID ) {
			$footer = get_post( $translated_footer_id );
		}
		global $wp_query, $vc_manager, $us_is_in_footer, $us_footer_id;
		$us_is_in_footer = TRUE;
		$us_footer_id = $translated_footer_id;
		$wp_query = new WP_Query( array(
			'p' => $translated_footer_id,
			'post_type' => 'any'
		) );
		if ( ! empty( $vc_manager ) AND is_object( $vc_manager )) {
			$vc_manager->vc()->addPageCustomCss( $translated_footer_id );
			$vc_manager->vc()->addShortcodesCustomCss( $translated_footer_id );
		}
		$footer_content = $footer->post_content;
	}
	us_close_wp_query_context();

	// Apply filters to Page Block content and echoing it ouside of us_open_wp_query_context,
	// so all WP widgets (like WP Nav Menu) would work as they should
	echo apply_filters( 'us_page_block_the_content', $footer_content );

	$us_is_in_footer = FALSE;
}
?>
</footer>
<?php
	do_action( 'us_after_footer' );
}
if ( us_get_option( 'back_to_top', 1 ) ) {
	?>
	<a class="w-toplink pos_<?php echo us_get_option( 'back_to_top_pos', 'right' ) ?>" href="#" title="<?php _e( 'Back to top', 'us' ); ?>" aria-hidden="true"></a>
	<?php
}
if ( $us_layout->header_show != 'never' ) {
	?>
	<a class="w-header-show" href="javascript:void(0);"><span><?php echo us_translate( 'Menu' ) ?></span></a>
	<div class="w-header-overlay"></div>
	<?php
	}
?>
<script>
	// Store some global theme options used in JS
	if (window.$us === undefined) window.$us = {};
	$us.canvasOptions = ($us.canvasOptions || {});
	$us.canvasOptions.disableEffectsWidth = <?php echo intval( us_get_option( 'disable_effects_width', 900 ) ) ?>;
	$us.canvasOptions.responsive = <?php echo us_get_option( 'responsive_layout', TRUE ) ? 'true' : 'false' ?>;
	$us.canvasOptions.backToTopDisplay = <?php echo intval( us_get_option( 'back_to_top_display', 100 ) ) ?>;
	$us.canvasOptions.scrollDuration = <?php echo intval( us_get_option( 'smooth_scroll_duration', 1000 ) ) ?>;

	$us.langOptions = ($us.langOptions || {});
	$us.langOptions.magnificPopup = ($us.langOptions.magnificPopup || {});
	$us.langOptions.magnificPopup.tPrev = '<?php _e( 'Previous (Left arrow key)', 'us' ); ?>';
	$us.langOptions.magnificPopup.tNext = '<?php _e( 'Next (Right arrow key)', 'us' ); ?>';
	$us.langOptions.magnificPopup.tCounter = '<?php _ex( '%curr% of %total%', 'Example: 3 of 12', 'us' ); ?>';

	$us.navOptions = ($us.navOptions || {});
	$us.navOptions.mobileWidth = <?php echo intval( us_get_option( 'menu_mobile_width', 900 ) ) ?>;
	$us.navOptions.togglable = <?php echo us_get_option( 'menu_togglable_type', TRUE ) ? 'true' : 'false' ?>;
	$us.ajaxLoadJs = <?php echo us_get_option( 'ajax_load_js', 0 ) ? 'true' : 'false' ?>;
	$us.templateDirectoryUri = '<?php global $us_template_directory_uri; echo $us_template_directory_uri; ?>';
</script>
<?php wp_footer(); ?>
</body>
</html>
