<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * The template for displaying the 404 page
 */

$page_404 = get_page_by_path( 'error-404' );
$us_layout = US_Layout::instance();

// Output page with 'error-404' slug
if ( $page_404 ) {
	if ( class_exists( 'SitePress' ) ) {
		$page_404 = get_post( apply_filters( 'wpml_object_id', $page_404->ID, 'page', TRUE ) );
	}

	get_header();

	us_load_template( 'templates/titlebar' );

	?>
	<div class="l-main">
		<div class="l-main-h i-cf">

			<main class="l-content"<?php echo ( us_get_option( 'schema_markup' ) ) ? ' itemprop="mainContentOfPage"' : ''; ?>>

				<?php
				do_action( 'us_before_page' );

				$the_content = apply_filters( 'the_content', $page_404->post_content );

				// The page may be paginated itself via <!--nextpage--> tags
				$pagination = wp_link_pages(
					array(
						'before' => '<nav class="post-pagination"><span class="title">' . us_translate( 'Pages:' ) . '</span>',
						'after' => '</nav>',
						'link_before' => '<span>',
						'link_after' => '</span>',
						'echo' => 0,
					)
				);

				// If content has no sections, we'll create them manually
				$has_own_sections = ( strpos( $the_content, ' class="l-section' ) !== FALSE );
				if ( ! $has_own_sections ) {
					$the_content = '<section class="l-section"><div class="l-section-h i-cf">' . $the_content . $pagination . '</div></section>';
				} elseif ( ! empty( $pagination ) ) {
					$the_content .= '<section class="l-section"><div class="l-section-h i-cf">' . $pagination . '</div></section>';
				}

				echo $the_content;

				do_action( 'us_after_page' );
				?>

			</main>

			<?php us_load_template( 'templates/sidebar' ) ?>

		</div>
	</div>
	<?php
// Output predefined layout
} else {
	$us_layout->sidebar_pos = 'none';
	get_header();
	?>
	<div class="l-main">
		<div class="l-main-h i-cf">

			<div class="l-content">

				<section class="l-section">
					<div class="l-section-h i-cf">

						<?php do_action( 'us_before_404' ) ?>

						<div class="page-404">

							<?php
							$the_content = '<h1>' . us_translate( 'Page not found' ) . '</h1><p>' . __( 'The link you followed may be broken, or the page may have been removed.', 'us' ) . '</p>';
							echo apply_filters( 'us_404_content', $the_content );
							?>

						</div>

						<?php do_action( 'us_after_404' ) ?>

					</div>
				</section>

			</div>

		</div>
	</div>
	<?php
}
get_footer();
?>
