<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Outputs page's Sidebar
 */

$public_cpt = array_keys( us_get_public_cpt() );

// Defaults
$sidebar_id = us_get_option( 'sidebar_id' );

// Portfolio Pages
if ( is_singular( array( 'us_portfolio' ) ) ) {
	$sidebar_id = us_get_option( 'sidebar_portfolio_id' );

// Posts
} elseif ( is_singular( array( 'post', 'attachment' ) ) ) {
	$sidebar_id = us_get_option( 'sidebar_post_id' );

// Search Results Page
} elseif ( is_search() ) {
	$sidebar_id = us_get_option( 'sidebar_search_id' );

// Blog Home Page
} elseif ( is_home() ) {
	$sidebar_id = us_get_option( 'sidebar_blog_id' );

// Shop & Products
} elseif ( function_exists( 'is_woocommerce' ) AND is_woocommerce() ) {
	if ( is_product() ) {
		$sidebar_id = us_get_option( 'sidebar_product_id' );
	} else {
		$sidebar_id = us_get_option( 'sidebar_shop_id' );
		if ( ! is_search() AND ! is_tax() ) {
			if ( usof_meta( 'us_sidebar', array(), wc_get_page_id( 'shop' ) ) == 'hide' ) {
				$sidebar_id = '';
			} elseif ( usof_meta( 'us_sidebar', array(), wc_get_page_id( 'shop' ) ) == 'custom' ) {
				$sidebar_id = usof_meta( 'us_sidebar_id', array(), wc_get_page_id( 'shop' ) );
			}
		}
	}

// Archive Pages
} elseif ( is_archive() ) {
	$sidebar_id = us_get_option( 'sidebar_archive_id' );

// Supported custom post types
} elseif ( is_array( $public_cpt ) AND count( $public_cpt ) > 0 AND is_singular( $public_cpt ) ) {
	$post_type = get_post_type();
	$sidebar_id = us_get_option( 'sidebar_' . $post_type . '_id' );
}

// Forums archive page
if ( is_post_type_archive( 'forum' ) ) {
	$sidebar_id = us_get_option( 'sidebar_forum_id' );
}

// Specific page
if ( is_singular() OR ( is_404() AND $page_404 = get_page_by_path( 'error-404' ) ) ) {
	if ( is_singular() ) {
		$postID = get_the_ID();
	} elseif ( is_404() ) {
		$postID = $page_404->ID;
	}
	if ( usof_meta( 'us_sidebar', array(), $postID ) == 'hide' ) {
		$sidebar_id = '';
	} elseif ( usof_meta( 'us_sidebar', array(), $postID ) == 'custom' ) {
		$sidebar_id = usof_meta( 'us_sidebar_id', array(), $postID );
	}
}

// Reset defaults
if ( $sidebar_id == '__defaults__' ) {
	$sidebar_id = us_get_option( 'sidebar_id' );
}

// Output content of registered Sidebar
if ( $sidebar_id != '' ) {
?>
<aside class="l-sidebar <?php echo esc_attr( $sidebar_id ) ?>"<?php echo ( us_get_option( 'schema_markup' ) ) ? ' itemscope itemtype="https://schema.org/WPSideBar"' : ''; ?>>
	<?php dynamic_sidebar( $sidebar_id ); ?>
</aside>
<?php
}
